<section class="plan pb-120">
  <div class="container-fluid container-wrapper">
    <div class="row g-4">
      <div class="col-xxl-5 col-xl-6 col-md-9 mx-auto">
        <div class="section-title d-flex align-items-center justify-content-center text-center">
          <h3 class="title-anim">{{getTranslatedArrayValue(@$plan_content->section_value, 'heading') }}</h3>
        </div>
      </div>
    </div>

    <div class="plan-card-wrapper">
      <div class="row g-4">
        @foreach($plans->take(3) as $plan)

        <div class="col-lg-4 col-md-6 fade-item">
          <div class="plan-card {{$plan->recommended_status == \App\Enums\StatusEnum::TRUE->status() ? 'recommend' : ''}}">
            <span class="plan-title"> {{ucfirst($plan->name)}}</span>

            <p class="plan-desc">
             {{$plan->description}}
            </p>

            <div class="price">
              <h5><span>{{ getDefaultCurrencySymbol(json_decode(site_settings("currencies"), true)) }}</span>{{shortAmount($plan->amount)}}</h5>
              <p>{{ $plan->duration ?? translate('N/A')}} {{ translate(" / Days")  }}</p>
            </div>

            <div class="plan-features">
              <h5>{{ translate("What's Include?") }}</h5>
              <ul class="pricing-list">
                  @if($plan->carry_forward == \App\Enums\StatusEnum::TRUE->status())
                      <li><i class="bi bi-check-circle-fill"></i>{{ translate("Credit carry forward when renewed") }}</li>
                  @endif
                  @if($plan->sms->android->is_allowed == true || $plan->whatsapp->is_allowed == true || $plan->sms->is_allowed == true || $plan->email->is_allowed == true)


                      @if($plan->type == \App\Enums\StatusEnum::FALSE->status() && ($plan->sms->android->is_allowed == true || $plan->whatsapp->is_allowed == true))

                          @if($plan->sms->android->is_allowed == true)
                              <li> <i class="bi bi-check-circle-fill"></i>{{ translate('Add ')}} {{ $plan->sms->android->gateway_limit == 0 ? "unlimited" : $plan->sms->android->gateway_limit }}{{ translate(" Android Gateways")}}</li>
                          @endif
                          @if($plan->whatsapp->is_allowed == true)
                              <li><i class="bi bi-check-circle-fill"></i>{{ translate('Add ')}} {{ $plan->whatsapp->gateway_limit == 0 ? "unlimited" : $plan->whatsapp->gateway_limit }} {{translate(" Whatsapp devices")}}</li>
                          @endif

                      @elseif($plan->type == \App\Enums\StatusEnum::TRUE->status() && $plan->sms->android->is_allowed == true && $plan->whatsapp->is_allowed == true)

                          <li><i class="bi bi-check-circle-fill"></i>{{ translate("Admin Gateways: ")}}
                              @if($plan->sms->is_allowed == true) {{ translate(" SMS ") }} @endif
                              @if($plan->sms->android->is_allowed == true) {{ translate(" Android ") }} @endif
                              @if($plan->email->is_allowed == true) {{ translate(" Email ") }} @endif
                          </li>

                      @endif

                      @if($plan->type == \App\Enums\StatusEnum::TRUE->status())
                          @if($plan->whatsapp->is_allowed == true)
                              <li><i class="bi bi-check-circle-fill"></i>{{ translate('Add ')}}{{ $plan->whatsapp->gateway_limit == 0 ? "unlimited" : $plan->whatsapp->gateway_limit }}{{translate(" Whatsapp devices")}}</li>
                          @endif

                      @elseif($plan->type == \App\Enums\StatusEnum::FALSE->status())
                          @if($plan->email->is_allowed == true)
                              @php
                                  $gateway_mail 		= (array)@$plan->email->allowed_gateways;
                                  $total_mail_gateway = 0;
                                  foreach ($gateway_mail as $email_value) { $total_mail_gateway += $email_value; }
                              @endphp
                              <li> <i class="bi bi-check-circle-fill"></i>{{ translate('Add up To ') }}{{ $total_mail_gateway }} {{ translate(" Mail Gateways") }}</li>
                          @endif
                          @if($plan->sms->is_allowed == true)
                              @php
                                  $gateway_sms 	   = (array)@$plan->sms->allowed_gateways;
                                  $total_sms_gateway = 0;
                                  foreach ($gateway_sms as $sms_value) { $total_sms_gateway += $sms_value; }

                              @endphp
                              <li> <i class="bi bi-check-circle-fill"></i>{{ translate('Add Up To ') }} {{ $total_sms_gateway }} {{ translate(" SMS Gateways") }}</li>
                          @endif
                      @endif
                  @endif

                  @if(!is_null($plan->sms_gateways))
                      <li><i class="bi bi-check-circle-fill"></i>{{ translate('Add ') }}{{$plan->total_sms_gateway}}{{ translate(" gateways from") }}<br/><b>{{strToUpper(implode(", ",($plan->sms_gateways)))}}</b></li>
                  @endif
                  <li class="d-flex flex-wrap"> <i class="bi bi-check-circle-fill"></i>@if($plan->email->credits != -1) {{$plan->email->credits}}{{ translate(' Email Credit') }} @else {{ translate("Unlimited Email Credits")}} @endif <span class="w-100 ps-1 ms-4 mt-1 fs-14 lh-1 {{$plan->recommended_status == \App\Enums\StatusEnum::FALSE->status() ? 'text-primary' : ''}} fw-medium me-0">@if(@$plan->email?->credits_per_day != 0){{ translate("Spend up to ").@$plan->email?->credits_per_day.translate(" credits per day") }}@else {{ translate("Spend unlimited credits per day") }}@endif</span></li>
                  <li class="d-flex flex-wrap"> <i class="bi bi-check-circle-fill"></i>@if($plan->sms->credits != -1) {{$plan->sms->credits}}{{translate(' SMS Credit') }} @else {{ translate("Unlimited SMS Credits")}} @endif <span class="w-100 ps-1 ms-4 mt-1 fs-14 lh-1 {{$plan->recommended_status == \App\Enums\StatusEnum::FALSE->status() ? 'text-primary' : ''}}  fw-medium me-0">@if(@$plan->sms?->credits_per_day != 0){{ translate("Spend up to ").@$plan->sms?->credits_per_day.translate(" credits per day") }}@else {{ translate("Spend unlimited credits per day") }}@endif</span></li>
                  <li class="d-flex flex-wrap"> <i class="bi bi-check-circle-fill"></i>@if($plan->whatsapp->credits != -1) {{$plan->whatsapp->credits}}{{translate(' WhatsApp Credit') }}@else {{ translate("Unlimited WhatsApp Credits")}} @endif <span class="w-100 ps-1 ms-4 mt-1 fs-14 lh-1 {{$plan->recommended_status == \App\Enums\StatusEnum::FALSE->status() ? 'text-primary' : ''}}  fw-medium me-0">@if(@$plan->whatsapp?->credits_per_day != 0){{ translate("Spend up to ").@$plan->whatsapp?->credits_per_day.translate(" credits per day") }}@else {{ translate("Spend unlimited credits per day") }}@endif</span></li>
                  <li> <i class="bi bi-check-circle-fill"></i>{{ translate('1 SMS Credit for '.site_settings("sms_word_count").' plain word')}}</li>
                  <li> <i class="bi bi-check-circle-fill"></i>{{ translate('1 SMS Credit for '.site_settings("sms_word_unicode_count").' unicode word')}}</li>
                  <li> <i class="bi bi-check-circle-fill"></i>{{ translate('1 WhatsApp Credit for '.site_settings("whatsapp_word_count").' word')}}</li>
                  <li> <i class="bi bi-check-circle-fill"></i>{{ translate('1 Email Credit per Email')}}</li>
              </ul>
            </div>

            <div class="plan-action">
              <a href="{{ route("login") }}" class="i-btn btn--primary btn--xl pill w-100">
                {{ translate("Purchase Now") }}
              </a>
            </div>
          </div>
        </div>
        @endforeach
      </div>
    </div>
  </div>
</section>
