@push("style-include")
  <link rel="stylesheet" href="{{ asset('assets/theme/global/css/select2.min.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/theme/global/css/chat-media.css')}}">
  <style>
    .message-box-wrapper {
      position: relative;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    .template-btn {
      background: #f0f2f5;
      border: none;
      border-radius: 50%;
      width: 40px;
      height: 40px;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: all 0.3s ease;
      color: #54656f;
    }
    .template-btn:hover {
      background: #e5e7eb;
      color: #128C7E;
    }
    .template-btn i {
      font-size: 20px;
    }
    .white-space-pre-line {
      white-space: pre-line;
    }
  </style>
@endpush
@extends('admin.layouts.app')
@section('panel')

 <main class="main-body p-0">
    <div class="container-fluid px-0 main-content">
      <div class="chat-wrapper">
        <!-- ==========Sidebar Left========== -->
        <div class="chat-left">
          <div class="chat-left-sidebar">
            <div class="nav chat-menus" role="tablist" aria-orientation="vertical">
              <div class="chat-menu">
                <div class="nav-item" role="presentation" data-bs-toggle="tooltip" data-bs-placement="right" data-bs-title="All Chats">
                  <a class="nav-link active" data-bs-toggle="tab" href="#chats" role="tab" aria-selected="true" data-type="all">
                    <i class="ri-question-answer-line"></i>
                  </a>
                </div>
                <div class="nav-item" role="presentation" data-bs-toggle="tooltip" data-bs-placement="right" data-bs-title="Pending">
                  <a class="nav-link" data-bs-toggle="tab" href="#pending" role="tab" aria-selected="false" data-type="pending">
                    <i class="ri-hourglass-line"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <div class="chat-sidebar-wrapper">
            <div class="tab-content h-100">
              <div class="tab-pane fade show active" id="chats" role="tabpanel" aria-labelledby="chats-tab" tabindex="0">
                <div class="chat-sidebar-header">
                  <h5>{{ translate("All Chats") }}</h5>
                  <div class="d-flex align-items-center gap-lg-3 gap-2">
                    <div class="dropdown dropdown-search">
                      <button class="icon-btn bg-transparent fs-20 text-secondary" type="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-offset="10,10">
                        <i class="ri-search-line"></i>
                      </button>
                      <div class="dropdown-menu dropdown-menu-end p-2">
                        <form action="#" class="dropdown-form">
                          <i class="ri-search-line"></i>
                          <input type="search" class="form-control" id="conversation-search">
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="chat-sidebar-content">
                  <div class="chat-loader" id="conversations-loader" style="display: none;">
                    <div class="spinner"></div>
                  </div>
                  <ul class="chat-contacts" id="conversations-list"></ul>
                  <button class="load-more-btn" id="load-more-conversations" style="display: none;">{{ translate("Load More") }}</button>
                </div>
              </div>
              <!-- Pending tab -->
              <div class="tab-pane fade" id="pending" role="tabpanel" aria-labelledby="pending-tab" tabindex="0">
                <div class="chat-sidebar-header">
                  <h5>{{ translate("Pending") }}</h5>
                  <div class="d-flex align-items-center gap-lg-3 gap-2">
                    <div class="dropdown dropdown-search">
                      <button class="icon-btn bg-transparent fs-20 text-secondary" type="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-offset="10,10">
                        <i class="ri-search-line"></i>
                      </button>
                      <div class="dropdown-menu dropdown-menu-end p-2">
                        <form action="#" class="dropdown-form">
                          <i class="ri-search-line"></i>
                          <input type="search" class="form-control" id="pending-search">
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="chat-sidebar-content">
                  <div class="chat-loader" id="pending-loader" style="display: none;">
                    <div class="spinner"></div>
                  </div>
                  <ul class="chat-contacts" id="pending-list"></ul>
                  <button class="load-more-btn" id="load-more-pending" style="display: none;">{{ translate("Load More") }}</button>
                </div>
              </div>
              <!-- Profile tab (preserved from old) -->
              <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">
                <div class="chat-sidebar-content">
                  <ul class="chat-contacts" id="profile-list"></ul>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- ==========Chat Content========== -->
        <div class="chat-body">
          <div class="no-conversation-selected" id="no-conversation-state" style="display: flex;">
            <i class="ri-chat-3-line empty-chat-icon"></i>
            <h4>{{ translate("Select a conversation") }}</h4>
            <p class="text-muted">{{ translate("Choose a conversation from the sidebar to start messaging") }}</p>

            <button class="show-contact-sidebar i-btn btn--primary btn--sm mt-4 d-lg-none d-block">
                  {{ translate("Show Chat List") }}
                </button>
          </div>
          <div class="chat-interface" id="chat-interface" style="display: none;">
            <div class="chat-body-header">
              <div class="left">
                <button class="show-contact-sidebar">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="m22 11h-17.586l5.293-5.293a1 1 0 1 0 -1.414-1.414l-7 7a1 1 0 0 0 0 1.414l7 7a1 1 0 0 0 1.414-1.414l-5.293-5.293h17.586a1 1 0 0 0 0-2z" />
                  </svg>
                </button>
                <div class="chat-user-wrapper show-user-btn" role="button">
                  <div class="chat-user-info">
                    <p id="contact-name"></p>
                    <span id="contact-number"></span>
                  </div>
                </div>
              </div>
              <div class="right">
                <div class="d-flex align-items-center gap-lg-3 gap-2">
                  <div class="dropdown dropdown-search">
                    <button class="icon-btn bg-transparent fs-20 text-secondary" type="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-offset="10,10">
                      <i class="ri-search-line"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end p-2">
                      <form action="#" class="dropdown-form">
                        <i class="ri-search-line"></i>
                        <input type="search" class="form-control" id="message-search">
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="chatting-body">
              <div class="chat-loader" id="messages-loader" style="display: none;">
                <div class="spinner"></div>
              </div>
              <ul class="chatting" id="messages-list"></ul>
              <button class="load-more-btn" id="load-more-messages" style="display: none;">{{ translate("Load More") }}</button>
            </div>
            <div class="chat-body-footer">
              <div class="nav-main-chat">
                <ul>
                  <li>
                    <button class="active">{{ translate("Reply") }}</button>
                  </li>
                </ul>
              </div>
              <div class="message-box-wrapper">
                <button type="button" class="template-btn" id="chat-template-btn" title="{{ translate("Use Template") }}">
                  <i class="ri-layout-fill"></i>
                </button>
                <form action="{{ route('admin.communication.whatsapp.chats.send') }}" class="chat-form" method="POST" id="message-form">
                  @csrf
                  <input type="hidden" name="conversation_id" id="conversation_id" value="">
                  <input type="text" name="body" placeholder="{{ translate("Type a message") }}" id="message-input" required />
                  <button type="submit" class="chat-submit-btn">
                    <i class="ri-send-plane-fill"></i>
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>
{{-- Delete Conversation Modal --}}
<div class="modal fade actionModal" id="deleteConversationModal" tabindex="-1" aria-labelledby="deleteConversationModal" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header text-start">
        <span class="action-icon danger">
          <i class="bi bi-exclamation-circle"></i>
        </span>
      </div>
      <div class="modal-body">
        <div class="action-message">
          <h5>{{ translate("Are you sure you want to delete this conversation?") }}</h5>
          <p class="text-muted">{{ translate("All messages in this conversation will be permanently deleted. This action cannot be undone.") }}</p>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal">{{ translate("Cancel") }}</button>
        <button type="button" class="i-btn btn--danger btn--lg" id="confirmDeleteConversation">{{ translate("Delete") }}</button>
      </div>
    </div>
  </div>
</div>

{{-- Template Selection Modal --}}
<div class="modal fade" id="chatTemplateModal" tabindex="-1" aria-labelledby="chatTemplateModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="chatTemplateModalLabel">{{ translate("Select WhatsApp Template") }}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="chat-template-select" class="form-label">{{ translate("Choose a template") }}</label>
          <select class="form-select" id="chat-template-select">
            <option value="">{{ translate("Select template...") }}</option>
            @foreach($templates ?? [] as $template)
              <option value="{{ $template->id }}" data-message="{{ Arr::get($template->template_data, 'message', '') }}">
                {{ $template->name }}
              </option>
            @endforeach
          </select>
        </div>
        <div id="template-preview" class="border rounded p-3 bg-light" style="display:none;">
          <label class="form-label fw-bold">{{ translate("Preview") }}:</label>
          <p id="template-preview-text" class="mb-0 white-space-pre-line"></p>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="i-btn btn--dark outline btn--md" data-bs-dismiss="modal">{{ translate("Cancel") }}</button>
        <button type="button" class="i-btn btn--primary btn--md" id="insert-template-btn" disabled>{{ translate("Insert") }}</button>
      </div>
    </div>
  </div>
</div>

@endsection
@push("script-include")
  <script src="{{asset('assets/theme/global/js/chat.js')}}"></script>
  <script src="{{asset('assets/theme/global/js/select2.min.js')}}"></script>
@endpush
@push('script-push')
  @include('admin.communication.whatsapp.chats.js.enhanced-script', [
    'getConversationsRoute' => route('admin.communication.whatsapp.chats.conversations'),
    'showRoute'             => route('admin.communication.whatsapp.chats.show', ['conversation' => ':id']),
    'searchMessagesRoute'   => route('admin.communication.whatsapp.chats.search-messages', ['conversation' => ':id']),
    'loadMoreMessagesRoute' => route('admin.communication.whatsapp.chats.load-more-messages', ['conversation' => ':id'])
  ])

  <script>
  $(document).ready(function() {
      let selectedTemplateMessage = '';

      // Open template modal
      $('#chat-template-btn').on('click', function() {
          $('#chatTemplateModal').modal('show');
      });

      // Handle template selection
      $('#chat-template-select').on('change', function() {
          const selectedOption = $(this).find('option:selected');
          selectedTemplateMessage = selectedOption.data('message') || '';

          if (selectedTemplateMessage) {
              $('#template-preview-text').text(selectedTemplateMessage);
              $('#template-preview').show();
              $('#insert-template-btn').prop('disabled', false);
          } else {
              $('#template-preview').hide();
              $('#insert-template-btn').prop('disabled', true);
          }
      });

      // Insert template into message input
      $('#insert-template-btn').on('click', function() {
          if (selectedTemplateMessage) {
              $('#message-input').val(selectedTemplateMessage);
              $('#chatTemplateModal').modal('hide');

              // Reset modal
              $('#chat-template-select').val('');
              $('#template-preview').hide();
              $('#insert-template-btn').prop('disabled', true);
              selectedTemplateMessage = '';

              // Focus on message input
              $('#message-input').focus();
          }
      });

      // Reset modal when closed
      $('#chatTemplateModal').on('hidden.bs.modal', function() {
          $('#chat-template-select').val('');
          $('#template-preview').hide();
          $('#insert-template-btn').prop('disabled', true);
          selectedTemplateMessage = '';
      });
  });
  </script>
@endpush  