@push("style-include")
  <link rel="stylesheet" href="{{ asset('assets/theme/global/css/select2.min.css')}}">
  <link rel="stylesheet" href="{{ asset('assets/theme/global/css/chat-media.css')}}">
  <style>
    .template-btn {
      background: transparent;
      border: none;
      font-size: 20px;
      color: #6c757d;
      cursor: pointer;
      padding: 8px;
      display: inline-flex;
      align-items: center;
      justify-content: center;
    }
    .template-btn:hover {
      color: #495057;
    }
    .template-modal .template-item {
      padding: 12px;
      border: 1px solid #e9ecef;
      border-radius: 6px;
      margin-bottom: 10px;
      cursor: pointer;
      transition: all 0.2s;
    }
    .template-modal .template-item:hover {
      background-color: #f8f9fa;
      border-color: var(--color-primary);
    }
    .template-modal .template-item h6 {
      margin-bottom: 5px;
      color: #212529;
    }
    .template-modal .template-item p {
      margin-bottom: 0;
      color: #6c757d;
      font-size: 0.875rem;
    }
  </style>
@endpush
@extends('user.layouts.app')
@section('panel')

 <main class="main-body p-0">
    <div class="container-fluid px-0 main-content">
      <div class="chat-wrapper">
        <!-- ==========Sidebar Left========== -->
        <div class="chat-left">
          <div class="chat-left-sidebar">
            <div class="nav chat-menus" role="tablist" aria-orientation="vertical">
              <div class="chat-menu">
                <div class="nav-item" role="presentation" data-bs-toggle="tooltip" data-bs-placement="right" data-bs-title="All Chats">
                  <a class="nav-link active" data-bs-toggle="tab" href="#chats" role="tab" aria-selected="true" data-type="all">
                    <i class="ri-question-answer-line"></i>
                  </a>
                </div>
                <div class="nav-item" role="presentation" data-bs-toggle="tooltip" data-bs-placement="right" data-bs-title="Pending">
                  <a class="nav-link" data-bs-toggle="tab" href="#pending" role="tab" aria-selected="false" data-type="pending">
                    <i class="ri-hourglass-line"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <div class="chat-sidebar-wrapper">
            <div class="tab-content h-100">
              <div class="tab-pane fade show active" id="chats" role="tabpanel" aria-labelledby="chats-tab" tabindex="0">
                <div class="chat-sidebar-header">
                  <h5>{{ translate("All Chats") }}</h5>
                  <div class="d-flex align-items-center gap-lg-3 gap-2">
                    <div class="dropdown dropdown-search">
                      <button class="icon-btn bg-transparent fs-20 text-secondary" type="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-offset="10,10">
                        <i class="ri-search-line"></i>
                      </button>
                      <div class="dropdown-menu dropdown-menu-end p-2">
                        <form action="#" class="dropdown-form">
                          <i class="ri-search-line"></i>
                          <input type="search" class="form-control" id="conversation-search">
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="chat-sidebar-content">
                  <div class="chat-loader" id="conversations-loader" style="display: none;">
                    <div class="spinner"></div>
                  </div>
                  <ul class="chat-contacts" id="conversations-list"></ul>
                  <button class="load-more-btn" id="load-more-conversations" style="display: none;">{{ translate("Load More") }}</button>
                </div>
              </div>
              <!-- Pending tab -->
              <div class="tab-pane fade" id="pending" role="tabpanel" aria-labelledby="pending-tab" tabindex="0">
                <div class="chat-sidebar-header">
                  <h5>{{ translate("Pending") }}</h5>
                  <div class="d-flex align-items-center gap-lg-3 gap-2">
                    <div class="dropdown dropdown-search">
                      <button class="icon-btn bg-transparent fs-20 text-secondary" type="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-offset="10,10">
                        <i class="ri-search-line"></i>
                      </button>
                      <div class="dropdown-menu dropdown-menu-end p-2">
                        <form action="#" class="dropdown-form">
                          <i class="ri-search-line"></i>
                          <input type="search" class="form-control" id="pending-search">
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="chat-sidebar-content">
                  <div class="chat-loader" id="pending-loader" style="display: none;">
                    <div class="spinner"></div>
                  </div>
                  <ul class="chat-contacts" id="pending-list"></ul>
                  <button class="load-more-btn" id="load-more-pending" style="display: none;">{{ translate("Load More") }}</button>
                </div>
              </div>
              <!-- Profile tab (preserved from old) -->
              <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">
                <div class="chat-sidebar-content">
                  <ul class="chat-contacts" id="profile-list"></ul>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- ==========Chat Content========== -->
        <div class="chat-body">
          <div class="no-conversation-selected" id="no-conversation-state" style="display: flex;">
            <i class="ri-chat-3-line empty-chat-icon"></i>
            <h4>{{ translate("Select a conversation") }}</h4>
            <p class="text-muted">{{ translate("Choose a conversation from the sidebar to start messaging") }}</p>
            <button class="show-contact-sidebar i-btn btn--primary btn--sm mt-4 d-lg-none d-block">
                  {{ translate("Show Chat List") }}
                </button>
          </div>
          <div class="chat-interface" id="chat-interface" style="display: none;">
            <div class="chat-body-header">
              <div class="left">
                <button class="show-contact-sidebar">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="m22 11h-17.586l5.293-5.293a1 1 0 1 0 -1.414-1.414l-7 7a1 1 0 0 0 0 1.414l7 7a1 1 0 0 0 1.414-1.414l-5.293-5.293h17.586a1 1 0 0 0 0-2z" />
                  </svg>
                </button>
                <div class="chat-user-wrapper show-user-btn" role="button">
                  <div class="chat-user-info">
                    <p id="contact-name"></p>
                    <span id="contact-number"></span>
                  </div>
                </div>
              </div>
              <div class="right">
                <div class="d-flex align-items-center gap-lg-3 gap-2">
                  <div class="dropdown dropdown-search">
                    <button class="icon-btn bg-transparent fs-20 text-secondary" type="button" data-bs-toggle="dropdown" aria-expanded="false" data-bs-offset="10,10">
                      <i class="ri-search-line"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end p-2">
                      <form action="#" class="dropdown-form">
                        <i class="ri-search-line"></i>
                        <input type="search" class="form-control" id="message-search">
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="chatting-body">
              <div class="chat-loader" id="messages-loader" style="display: none;">
                <div class="spinner"></div>
              </div>
              <ul class="chatting" id="messages-list"></ul>
              <button class="load-more-btn" id="load-more-messages" style="display: none;">{{ translate("Load More") }}</button>
            </div>
            <div class="chat-body-footer">
              <div class="nav-main-chat">
                <ul>
                  <li>
                    <button class="active">{{ translate("Reply") }}</button>
                  </li>
                </ul>
              </div>
              <div class="message-box-wrapper">
                <form action="{{ route('user.communication.whatsapp.chats.send') }}" class="chat-form" method="POST" id="message-form">
                  @csrf
                  <input type="hidden" name="conversation_id" id="conversation_id" value="">
                  <button type="button" class="template-btn" id="chat-template-btn" title="{{ translate("Use Template") }}">
                    <i class="ri-layout-fill"></i>
                  </button>
                  <input type="text" name="body" placeholder="{{ translate("Type a message") }}" id="message-input" required />
                  <button type="submit" class="chat-submit-btn">
                    <i class="ri-send-plane-fill"></i>
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Template Modal -->
  <div class="modal fade" id="templateModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">{{ translate("Select Template") }}</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body template-modal">
          @forelse($templates ?? [] as $template)
            <div class="template-item" data-message="{{ $template->template_data['message'] ?? '' }}">
              <h6>{{ $template->name }}</h6>
              <p>{{ \Illuminate\Support\Str::limit($template->template_data['message'] ?? '', 100) }}</p>
            </div>
          @empty
            <p class="text-center text-muted">{{ translate("No templates available") }}</p>
          @endforelse
        </div>
      </div>
    </div>
  </div>
@endsection
@push("script-include")
  <script src="{{asset('assets/theme/global/js/chat.js')}}"></script>
  <script src="{{asset('assets/theme/global/js/select2.min.js')}}"></script>
@endpush
@push('script-push')
  <script>
    // Template selector functionality
    $(document).ready(function() {
      const templateModal = new bootstrap.Modal(document.getElementById('templateModal'));

      // Open template modal
      $('#chat-template-btn').on('click', function() {
        templateModal.show();
      });

      // Handle template selection
      $('.template-item').on('click', function() {
        const message = $(this).data('message');
        $('#message-input').val(message);
        templateModal.hide();
      });
    });
  </script>

  @include('user.communication.whatsapp.chats.js.enhanced-script', [
    'getConversationsRoute' => route('user.communication.whatsapp.chats.conversations'),
    'showRoute'             => route('user.communication.whatsapp.chats.show', ['conversation' => ':id']),
    'searchMessagesRoute'   => route('user.communication.whatsapp.chats.search-messages', ['conversation' => ':id']),
    'loadMoreMessagesRoute' => route('user.communication.whatsapp.chats.load-more-messages', ['conversation' => ':id'])
  ])
@endpush  